/*
   This program demonstrates the Java API for creating a process.

   See
      http://docs.oracle.com/javase/6/docs/api/java/lang/Runtime.html#getRuntime()
      http://docs.oracle.com/javase/6/docs/api/java/lang/Runtime.html#method_summary
*/

public class RunProgram
{
   public static void main(String[] args)
   {
      try
      {
         // Create a Windows command-line for running a (GUI) program.
         // Notice that there is one command-line argument.
         String[] cmd1 = {"notepad.exe",
                          "Runprogram.java"};
         // Execute the command line.
         java.lang.Runtime.getRuntime().exec(cmd1);



         // Create a Windows command-line for running another (GUI) program.
         // Notice that there are several command-line arguments.
         String[] cmd2 = {"explorer",
                          "/n",
                          "/e",
                          "/root,C:\\Windows\\System32"};
         // Execute the command line.
         java.lang.Runtime.getRuntime().exec(cmd2);



         // Create a Windows command-line for running another (GUI) program.
         String cmd3 = "calc.exe";
         // Execute the command-line.
         java.lang.Runtime.getRuntime().exec(cmd3);



         // Create a Windows command-line for running another program.
         // Notice that this is not a GUI program, it's a CLI program.
         String cmd4 = "ipconfig.exe";
         // Execute the command-line.
         java.lang.Runtime.getRuntime().exec(cmd4);
         // NOTE: There is no output from running this program.
         //       It should print output on the console screen,
         //       but it does not. This is one of the problems
         //       with having Java start up processes.
      }
      catch (Exception e)
      {
         System.out.println( e );
      }
   }//main()
}//RunProgram